(function($) {
    $(document).ready(function() {
        // Toggle key visibility
        $('.art8io-toggle-key').on('click', function() {
            var i = $('#art8io_api_key'), ic = $(this).find('.dashicons');
            i.attr('type') === 'password' ? (i.attr('type','text'), ic.removeClass('dashicons-visibility').addClass('dashicons-hidden')) : (i.attr('type','password'), ic.removeClass('dashicons-hidden').addClass('dashicons-visibility'));
        });

        // Validate key
        $('.art8io-validate-key-btn').on('click', function() {
            var btn = $(this), key = $('#art8io_api_key').val(), st = $('.art8io-key-status');
            if (!key) { st.html('<span class="dashicons dashicons-warning"></span> Ungültig').removeClass('valid'); return; }
            btn.prop('disabled', true).text(art8io.strings.validating);
            $.post(art8io.ajax_url, {action: 'art8io_validate_key', nonce: art8io.nonce, api_key: key}, function(r) {
                r.success ? st.html('<span class="dashicons dashicons-yes-alt"></span> ' + art8io.strings.valid).addClass('valid') : st.html('<span class="dashicons dashicons-warning"></span> ' + art8io.strings.invalid).removeClass('valid');
            }).always(function() { btn.prop('disabled', false).text('Testen'); });
        });

        // Sync all
        $('.art8io-sync-btn').on('click', function() {
            var btn = $(this), orig = btn.html();
            btn.prop('disabled', true).html('<span class="dashicons dashicons-update spin"></span> ' + art8io.strings.syncing);
            $.post(art8io.ajax_url, {action: 'art8io_sync_now', nonce: art8io.nonce}, function(r) {
                $('.art8io-sync-result').html('<div class="notice notice-' + (r.success ? 'success' : 'error') + '"><p>' + r.data + '</p></div>');
                if (r.success) setTimeout(function() { location.reload(); }, 1500);
            }).always(function() { btn.prop('disabled', false).html(orig); });
        });

        // Toggle details panel
        $('.art8io-toggle-details').on('click', function() {
            var btn = $(this);
            var details = btn.closest('.art8io-queue-item').find('.art8io-queue-item-details');
            var icon = btn.find('.dashicons');
            
            details.slideToggle(200);
            icon.toggleClass('dashicons-arrow-down-alt2 dashicons-arrow-up-alt2');
        });

        // Character count for SEO fields
        $('.art8io-field-meta-title').on('input', function() {
            $(this).closest('.art8io-field').find('.count').text($(this).val().length);
        });
        $('.art8io-field-meta-desc').on('input', function() {
            $(this).closest('.art8io-field').find('.count').text($(this).val().length);
        });

                    btn.prop('disabled', false).html('<span class="dashicons dashicons-download"></span> Importieren');
                }
            });
        });

        // Delete from queue
        $('.art8io-delete-item').on('click', function() {
            if (!confirm('Diesen Eintrag aus der Queue entfernen?')) return;
            var btn = $(this), container = btn.closest('.art8io-queue-item'), itemId = btn.data('id');
            btn.prop('disabled', true).html('<span class="dashicons dashicons-update spin"></span>');
            $.post(art8io.ajax_url, {action: 'art8io_delete_item', nonce: art8io.nonce, item_id: itemId}, function(r) {
                if (r.success) {
                    container.slideUp(300, function() { $(this).remove(); });
                } else {
                    alert(r.data || 'Fehler beim Löschen');
                    btn.prop('disabled', false).html('<span class="dashicons dashicons-trash"></span>');
                }
            });
        });

        // Show full content modal
        $('.art8io-show-full-content').on('click', function(e) {
            e.preventDefault();
            var content = $(this).data('content');
            $('#art8io-full-content').html(content);
            $('#art8io-content-modal').show();
        });

        // Modal close
        $('.art8io-modal-close, .art8io-modal').on('click', function(e) { 
            if (e.target === this) {
                $('.art8io-modal').hide();
            }
        });
        $(document).on('keydown', function(e) { 
            if (e.key === 'Escape') $('.art8io-modal').hide(); 
        });
    });
    
    // Spin animation
    $('<style>.spin{animation:spin 1s linear infinite}@keyframes spin{from{transform:rotate(0)}to{transform:rotate(360deg)}}</style>').appendTo('head');
})(jQuery);
