<?php
/**
 * Plugin Name: art8.io - AI Content Push
 * Plugin URI: https://art8.io
 * Description: Pushe KI-optimierten Content direkt von art8.io in dein WordPress als Draft.
 * Version: 1.6.0.1
 * Author: art8.io
 * Author URI: https://art8.io
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: art8io
 * Domain Path: /languages
 * Requires at least: 5.0
 * Requires PHP: 7.4
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Plugin constants
define('ART8IO_VERSION', '1.6.0.1');
define('ART8IO_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('ART8IO_PLUGIN_URL', plugin_dir_url(__FILE__));
define('ART8IO_API_URL', 'https://api.art8.io/api/plugins');

// Include required files
require_once ART8IO_PLUGIN_DIR . 'includes/class-art8io-api.php';
require_once ART8IO_PLUGIN_DIR . 'includes/class-art8io-cron.php';
require_once ART8IO_PLUGIN_DIR . 'includes/class-art8io-updater.php';
require_once ART8IO_PLUGIN_DIR . 'admin/class-art8io-admin.php';

/**
 * Main Plugin Class
 */
class Art8io {
    
    private static $instance = null;
    
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct() {
        $this->init_hooks();
    }
    
    private function init_hooks() {
        // Activation/Deactivation
        register_activation_hook(__FILE__, array($this, 'activate'));
        register_deactivation_hook(__FILE__, array($this, 'deactivate'));
        
        // Init
        add_action('init', array($this, 'init'));
        
        // Admin
        if (is_admin()) {
            new Art8io_Admin();
        }
        
        // Cron
        new Art8io_Cron();
        new Art8io_Updater();
    }
    
    public function init() {
        load_plugin_textdomain('art8io', false, dirname(plugin_basename(__FILE__)) . '/languages');
    }
    
    public function activate() {
        // Create options with defaults
        add_option('art8io_api_key', '');
        add_option('art8io_sync_interval', '15');
        add_option('art8io_auto_draft', '1');
        add_option('art8io_post_type', 'post');
        add_option('art8io_last_sync', '');
        
        // Schedule cron
        if (!wp_next_scheduled('art8io_sync_cron')) {
            wp_schedule_event(time(), 'art8io_interval', 'art8io_sync_cron');
        }
        
        // Create logs table
        $this->create_logs_table();
    }
    
    public function deactivate() {
        // Clear cron
        wp_clear_scheduled_hook('art8io_sync_cron');
    }
    
    private function create_logs_table() {
        global $wpdb;
        $table_name = $wpdb->prefix . 'art8io_logs';
        
        $charset_collate = $wpdb->get_charset_collate();
        
        $sql = "CREATE TABLE IF NOT EXISTS $table_name (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            action varchar(50) NOT NULL,
            message text NOT NULL,
            status varchar(20) NOT NULL,
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (id)
        ) $charset_collate;";
        
        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }
}

// Initialize plugin
Art8io::get_instance();
