<?php
if (!defined('ABSPATH')) exit;

$api = new Art8io_API();
$status = $api->get_status();
$queue_result = $status['connected'] ? $api->get_queue('pending', 50) : null;
$items = array();

if ($queue_result && !is_wp_error($queue_result) && isset($queue_result['items'])) {
    $items = $queue_result['items'];
}

$post_types = get_post_types(array('public' => true), 'objects');
$categories = get_categories(array('hide_empty' => false));
$pages = get_pages(array('sort_column' => 'post_title'));
$product_cats = taxonomy_exists('product_cat') ? get_terms(array('taxonomy' => 'product_cat', 'hide_empty' => false)) : array();
$authors = get_users(array('role__in' => array('administrator', 'editor', 'author'), 'orderby' => 'display_name'));
$default_post_type = get_option('art8io_post_type', 'post');
$default_category = get_option('art8io_default_category', '');
?>
<div class="wrap art8io-wrap">
    <h1><?php _e('Content Queue', 'art8io'); ?></h1>

    <?php if (!$status['connected']): ?>
        <div class="notice notice-warning">
            <p><?php _e('Nicht mit art8.io verbunden. Bitte API Key in den Einstellungen hinterlegen.', 'art8io'); ?></p>
        </div>
    <?php elseif (empty($items)): ?>
        <div class="art8io-empty-state">
            <span class="dashicons dashicons-yes-alt"></span>
            <h2>Queue ist leer</h2>
            <p>Keine ausstehenden Inhalte. Erstelle neuen Content in <a href="https://art8.io/dashboard" target="_blank">art8.io</a></p>
        </div>
    <?php else: ?>
        <div class="art8io-card art8io-import-settings">
            <h3><span class="dashicons dashicons-admin-settings"></span> Import-Einstellungen</h3>
            <p class="description">Diese Einstellungen gelten für alle Importe auf dieser Seite.</p>
            
            <div class="art8io-settings-grid">
                <div class="art8io-setting">
                    <label for="art8io-import-post-type">Post-Typ</label>
                    <select id="art8io-import-post-type">
                        <?php foreach ($post_types as $pt): if ($pt->name === 'attachment') continue; ?>
                            <option value="<?php echo esc_attr($pt->name); ?>" <?php selected($default_post_type, $pt->name); ?>>
                                <?php echo esc_html($pt->label); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="art8io-setting" id="art8io-taxonomy-wrapper">
                    <label id="art8io-taxonomy-label">Kategorie</label>
                    <select id="art8io-import-category" class="art8io-tax-select" data-for="post">
                        <option value="">-- Keine --</option>
                        <?php foreach ($categories as $cat): ?>
                            <option value="<?php echo esc_attr($cat->term_id); ?>"><?php echo esc_html($cat->name); ?></option>
                        <?php endforeach; ?>
                    </select>
                    <select id="art8io-import-parent" class="art8io-tax-select" data-for="page" style="display:none;">
                        <option value="">-- Keine (Hauptseite) --</option>
                        <?php foreach ($pages as $p): ?>
                            <option value="<?php echo esc_attr($p->ID); ?>"><?php echo esc_html($p->post_title); ?></option>
                        <?php endforeach; ?>
                    </select>
                    <select id="art8io-import-product-cat" class="art8io-tax-select" data-for="product" style="display:none;">
                        <option value="">-- Keine --</option>
                        <?php if (!empty($product_cats) && !is_wp_error($product_cats)): foreach ($product_cats as $pcat): ?>
                            <option value="<?php echo esc_attr($pcat->term_id); ?>"><?php echo esc_html($pcat->name); ?></option>
                        <?php endforeach; endif; ?>
                    </select>
                </div>
                
                <div class="art8io-setting">
                    <label for="art8io-import-status">Status nach Import</label>
                    <select id="art8io-import-status">
                        <option value="draft">Entwurf</option>
                        <option value="publish">Veröffentlicht</option>
                        <option value="pending">Ausstehend (Review)</option>
                    </select>
                </div>
                
                <div class="art8io-setting">
                    <label for="art8io-import-author">Autor</label>
                    <select id="art8io-import-author">
                        <option value="">-- Aktueller Benutzer --</option>
                        <?php foreach ($authors as $author): ?>
                            <option value="<?php echo esc_attr($author->ID); ?>"><?php echo esc_html($author->display_name); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
        </div>

        <div class="art8io-queue-header-bar">
            <span class="art8io-queue-count"><strong><?php echo count($items); ?></strong> Inhalte in der Queue</span>
        </div>

        <?php foreach ($items as $item): 
            $content_data = $item['content'];
            if (is_string($content_data)) {
                $parsed = json_decode($content_data, true);
                if (json_last_error() === JSON_ERROR_NONE && is_array($parsed)) {
                    $content_data = $parsed;
                }
            }
            $title = isset($content_data['title']) ? $content_data['title'] : (isset($item['title']) ? $item['title'] : 'Ohne Titel');
            $meta_title = isset($content_data['meta_title']) ? $content_data['meta_title'] : '';
            $meta_desc = isset($content_data['meta_description']) ? $content_data['meta_description'] : '';
            $focus_kw = isset($content_data['focus_keyword']) ? $content_data['focus_keyword'] : '';
            $summary = isset($content_data['summary']) ? $content_data['summary'] : '';
            $actual_content = isset($content_data['content']) ? $content_data['content'] : '';
            $content_type = isset($item['content_type']) ? $item['content_type'] : 'post';
            $word_count = str_word_count(strip_tags($actual_content));
        ?>
        <div class="art8io-queue-item art8io-card" data-item-id="<?php echo esc_attr($item['id']); ?>">
            <div class="art8io-queue-item-header">
                <div class="art8io-queue-item-info">
                    <span class="art8io-toggle-icon dashicons dashicons-arrow-right-alt2"></span>
                    <div class="art8io-queue-item-title">
                        <strong><?php echo esc_html($title); ?></strong>
                        <div class="art8io-queue-item-meta">
                            <span class="art8io-badge type"><?php echo esc_html($content_type); ?></span>
                            <span class="art8io-meta-item"><span class="dashicons dashicons-calendar-alt"></span> <?php echo date_i18n('d.m.Y H:i', strtotime($item['created_at'])); ?></span>
                            <span class="art8io-meta-item"><span class="dashicons dashicons-editor-paragraph"></span> ~<?php echo $word_count; ?> Wörter</span>
                            <?php if ($focus_kw): ?><span class="art8io-meta-item art8io-keyword"><span class="dashicons dashicons-tag"></span> <?php echo esc_html($focus_kw); ?></span><?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="art8io-queue-item-actions">
                    <button type="button" class="art8io-btn art8io-btn-primary art8io-import-item" data-item='<?php echo esc_attr(json_encode($item)); ?>'>
                        <span class="dashicons dashicons-download"></span> Importieren
                    </button>
                    <button type="button" class="art8io-btn art8io-btn-danger art8io-delete-item" data-id="<?php echo esc_attr($item['id']); ?>">
                        <span class="dashicons dashicons-trash"></span>
                    </button>
                </div>
            </div>
            
            <div class="art8io-queue-item-details">
                <?php if ($meta_title): ?>
                <div class="art8io-detail-row">
                    <label><span class="dashicons dashicons-search"></span> Meta Title</label>
                    <div class="art8io-detail-value art8io-seo-field">
                        <?php echo esc_html($meta_title); ?>
                        <span class="art8io-char-count <?php echo strlen($meta_title) > 60 ? 'warning' : 'ok'; ?>"><?php echo strlen($meta_title); ?>/60</span>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if ($meta_desc): ?>
                <div class="art8io-detail-row">
                    <label><span class="dashicons dashicons-editor-alignleft"></span> Meta Description</label>
                    <div class="art8io-detail-value art8io-seo-field">
                        <?php echo esc_html($meta_desc); ?>
                        <span class="art8io-char-count <?php echo strlen($meta_desc) > 160 ? 'warning' : 'ok'; ?>"><?php echo strlen($meta_desc); ?>/160</span>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if ($summary): ?>
                <div class="art8io-detail-row">
                    <label><span class="dashicons dashicons-format-quote"></span> Zusammenfassung</label>
                    <div class="art8io-detail-value art8io-summary"><?php echo esc_html($summary); ?></div>
                </div>
                <?php endif; ?>
                
                <?php if ($actual_content): ?>
                <div class="art8io-detail-row">
                    <label><span class="dashicons dashicons-media-text"></span> Content</label>
                    <div class="art8io-detail-value art8io-content-preview">
                        <?php echo wp_kses_post(wpautop($actual_content)); ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>

<style>
.art8io-empty-state {
    text-align: center;
    padding: 60px 20px;
    background: #fff;
    border-radius: 8px;
    box-shadow: 0 1px 3px rgba(0,0,0,0.1);
}
.art8io-empty-state .dashicons {
    font-size: 64px;
    width: 64px;
    height: 64px;
    color: #00a32a;
    margin-bottom: 20px;
}
.art8io-empty-state h2 { margin: 0 0 10px; color: #1d2327; }
.art8io-empty-state p { color: #646970; margin: 0; }

.art8io-import-settings {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: #fff;
    padding: 20px !important;
}
.art8io-import-settings h3 {
    color: #fff;
    margin: 0 0 5px;
    display: flex;
    align-items: center;
    gap: 8px;
}
.art8io-import-settings .description { color: rgba(255,255,255,0.8); margin: 0 0 20px; }
.art8io-settings-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 15px;
}
.art8io-setting label {
    display: block;
    font-weight: 600;
    margin-bottom: 5px;
    font-size: 12px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}
.art8io-setting select {
    width: 100%;
    padding: 10px;
    border: none;
    border-radius: 6px;
    font-size: 14px;
}

.art8io-queue-header-bar {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 15px 0;
    border-bottom: 1px solid #e0e0e0;
    margin-bottom: 15px;
}
.art8io-queue-count { color: #646970; }

.art8io-queue-item {
    padding: 0 !important;
    margin-bottom: 12px;
    border-radius: 8px;
    overflow: hidden;
    transition: box-shadow 0.2s;
}
.art8io-queue-item:hover { box-shadow: 0 4px 12px rgba(0,0,0,0.1); }

.art8io-queue-item-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 15px 20px;
    cursor: pointer;
    background: #fff;
}
.art8io-queue-item-header:hover { background: #f9f9f9; }

.art8io-queue-item-info {
    display: flex;
    align-items: flex-start;
    gap: 12px;
    flex: 1;
}
.art8io-toggle-icon {
    color: #999;
    transition: transform 0.2s;
    margin-top: 2px;
}
.art8io-queue-item.expanded .art8io-toggle-icon { transform: rotate(90deg); }

.art8io-queue-item-title strong {
    font-size: 15px;
    color: #1d2327;
    display: block;
    margin-bottom: 6px;
}
.art8io-queue-item-meta {
    display: flex;
    flex-wrap: wrap;
    gap: 12px;
    font-size: 12px;
    color: #666;
}
.art8io-meta-item {
    display: flex;
    align-items: center;
    gap: 4px;
}
.art8io-meta-item .dashicons { font-size: 14px; width: 14px; height: 14px; }
.art8io-keyword { color: #2271b1; font-weight: 500; }

.art8io-badge.type {
    background: #e7f5ff;
    color: #1971c2;
    padding: 2px 8px;
    border-radius: 4px;
    font-weight: 500;
    text-transform: uppercase;
    font-size: 10px;
}

.art8io-queue-item-actions {
    display: flex;
    gap: 8px;
}

.art8io-btn {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 10px 18px;
    border: none;
    border-radius: 6px;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s;
}
.art8io-btn .dashicons { font-size: 16px; width: 16px; height: 16px; }
.art8io-btn-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: #fff;
}
.art8io-btn-primary:hover { transform: translateY(-1px); box-shadow: 0 4px 12px rgba(102,126,234,0.4); }
.art8io-btn-danger {
    background: #fee2e2;
    color: #dc2626;
    padding: 10px 12px;
}
.art8io-btn-danger:hover { background: #fecaca; }
.art8io-btn-success {
    background: #d1fae5;
    color: #059669;
}

.art8io-queue-item-details {
    display: none;
    padding: 20px;
    background: #f8fafc;
    border-top: 1px solid #e5e7eb;
}

.art8io-detail-row {
    margin-bottom: 15px;
}
.art8io-detail-row:last-child { margin-bottom: 0; }
.art8io-detail-row label {
    display: flex;
    align-items: center;
    gap: 6px;
    font-weight: 600;
    font-size: 12px;
    color: #374151;
    margin-bottom: 6px;
    text-transform: uppercase;
}
.art8io-detail-row label .dashicons { color: #667eea; font-size: 14px; width: 14px; height: 14px; }

.art8io-detail-value {
    background: #fff;
    padding: 12px 15px;
    border-radius: 6px;
    border: 1px solid #e5e7eb;
    font-size: 14px;
    line-height: 1.6;
}
.art8io-seo-field {
    position: relative;
    padding-right: 70px;
}
.art8io-char-count {
    position: absolute;
    right: 12px;
    top: 50%;
    transform: translateY(-50%);
    font-size: 11px;
    font-weight: 600;
    padding: 3px 8px;
    border-radius: 4px;
}
.art8io-char-count.ok { background: #d1fae5; color: #059669; }
.art8io-char-count.warning { background: #fef3c7; color: #d97706; }

.art8io-summary {
    background: #fefce8;
    border-color: #fde047;
    font-style: italic;
}

.art8io-content-preview {
    max-height: 400px;
    overflow-y: auto;
}
.art8io-content-preview h1, .art8io-content-preview h2, .art8io-content-preview h3 {
    margin-top: 1em;
    margin-bottom: 0.5em;
}
.art8io-content-preview p { margin-bottom: 1em; }

/* Imported state */
.art8io-queue-item.imported {
    opacity: 0.7;
}
.art8io-queue-item.imported .art8io-queue-item-header {
    background: #f0fdf4;
}
</style>

<script>
jQuery(function($) {
    var labels = { post: 'Kategorie', page: 'Übergeordnete Seite', product: 'Produkt-Kategorie' };
    
    $('#art8io-import-post-type').on('change', function() {
        var type = $(this).val();
        $('.art8io-tax-select').hide();
        if (type === 'page') {
            $('#art8io-import-parent').show();
            $('#art8io-taxonomy-label').text(labels.page);
        } else if (type === 'product') {
            $('#art8io-import-product-cat').show();
            $('#art8io-taxonomy-label').text(labels.product);
        } else {
            $('#art8io-import-category').show();
            $('#art8io-taxonomy-label').text(labels.post);
        }
    }).trigger('change');
    
    // Toggle details
    $('.art8io-queue-item-header').on('click', function(e) {
        if ($(e.target).closest('.art8io-btn').length) return;
        var $item = $(this).closest('.art8io-queue-item');
        $item.toggleClass('expanded');
        $item.find('.art8io-queue-item-details').slideToggle(200);
    });
    
    // Import
    $('.art8io-import-item').on('click', function(e) {
        e.stopPropagation();
        var btn = $(this);
        var container = btn.closest('.art8io-queue-item');
        var item = btn.data('item');
        
        var settings = {
            post_type: $('#art8io-import-post-type').val() || 'post',
            category_id: $('#art8io-import-category:visible').val() || $('#art8io-import-product-cat:visible').val() || 0,
            parent_id: $('#art8io-import-parent:visible').val() || 0,
            post_status: $('#art8io-import-status').val() || 'draft',
            author_id: $('#art8io-import-author').val() || 0
        };
        
        item.import_settings = settings;
        
        btn.prop('disabled', true).html('<span class="dashicons dashicons-update spin"></span> Importiere...');
        
        $.post(art8io.ajax_url, {
            action: 'art8io_import_single',
            nonce: art8io.nonce,
            item: JSON.stringify(item),
            settings: JSON.stringify(settings)
        }, function(r) {
            if (r.success) {
                container.addClass('imported');
                btn.removeClass('art8io-btn-primary').addClass('art8io-btn-success')
                   .html('<span class="dashicons dashicons-yes"></span> Importiert!');
                if (r.data.edit_url) {
                    btn.after('<a href="' + r.data.edit_url + '" class="art8io-btn" style="margin-left:8px;background:#e0e7ff;color:#4338ca;" target="_blank"><span class="dashicons dashicons-edit"></span> Bearbeiten</a>');
                }
                container.find('.art8io-delete-item').hide();
            } else {
                alert(r.data || 'Fehler beim Import');
                btn.prop('disabled', false).html('<span class="dashicons dashicons-download"></span> Importieren');
            }
        });
    });
    
    // Delete
    $('.art8io-delete-item').on('click', function(e) {
        e.stopPropagation();
        if (!confirm('Diesen Eintrag aus der Queue entfernen?')) return;
        var btn = $(this), container = btn.closest('.art8io-queue-item');
        btn.prop('disabled', true).html('<span class="dashicons dashicons-update spin"></span>');
        $.post(art8io.ajax_url, {
            action: 'art8io_delete_item',
            nonce: art8io.nonce,
            item_id: btn.data('id')
        }, function(r) {
            r.success ? container.slideUp(300, function() { $(this).remove(); }) : (alert(r.data || 'Fehler'), btn.prop('disabled', false).html('<span class="dashicons dashicons-trash"></span>'));
        });
    });
});
</script>
